/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DeerEntity
extends Animal {
    public DeerEntity(EntityType<? extends DeerEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createDeerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.215);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.22, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41864_, Items.f_42210_, Items.f_41865_}), true));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new EscapePlayerGoal(this, 2.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundInit.BABY_DEER_IDLE_EVENT : SoundInit.DEER_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return this.m_6162_() ? SoundInit.BABY_DEER_HURT_EVENT : SoundInit.DEER_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return this.m_6162_() ? SoundInit.BABY_DEER_HURT_EVENT : SoundInit.DEER_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public DeerEntity createChild(ServerLevel serverWorld, AgeableMob passiveEntity) {
        return (DeerEntity)EntityInit.DEER.m_20615_((Level)serverWorld);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_41864_) || stack.m_150930_(Items.f_41865_) || stack.m_150930_(Items.f_42210_);
    }

    private class EscapePlayerGoal
    extends Goal {
        protected final DeerEntity deerEntity;
        protected final double speed;
        protected double targetX;
        protected double targetY;
        protected double targetZ;

        public EscapePlayerGoal(DeerEntity deerEntity2, double speed) {
            this.deerEntity = deerEntity2;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.deerEntity.m_9236_().m_45930_((Entity)this.deerEntity, 4.0) == null) {
                return false;
            }
            return this.findTarget();
        }

        private boolean findTarget() {
            Vec3 vec3d = DefaultRandomPos.m_148403_((PathfinderMob)this.deerEntity, (int)12, (int)4);
            if (vec3d == null) {
                return false;
            }
            this.targetX = vec3d.f_82479_;
            this.targetY = vec3d.f_82480_;
            this.targetZ = vec3d.f_82481_;
            return true;
        }

        public void m_8056_() {
            this.deerEntity.m_21573_().m_26519_(this.targetX, this.targetY, this.targetZ, this.speed);
        }

        public boolean m_8045_() {
            return !this.deerEntity.m_21573_().m_26571_();
        }
    }
}

